---
title: Playwright MCP server is now compatible with Browser Rendering · Changelog
description: You can now deploy Playwright MCP and use any MCP client to get AI
  models to interact with Browser Rendering
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-05-28-playwright-mcp/
  md: https://developers.cloudflare.com/changelog/2025-05-28-playwright-mcp/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Playwright MCP server is now compatible with Browser Rendering

May 28, 2025

[Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

We're excited to share that you can now use the [Playwright MCP](https://github.com/cloudflare/playwright-mcp) server with Browser Rendering.

Once you [deploy the server](https://developers.cloudflare.com/browser-rendering/platform/playwright-mcp/#deploying), you can use any MCP client with it to interact with Browser Rendering. This allows you to run AI models that can automate browser tasks, such as taking screenshots, filling out forms, or scraping data.

![Access Analytics](https://developers.cloudflare.com/_astro/playground-ai-screenshot.v44jFMBu_2abDuJ.webp)

Playwright MCP is available as an npm package at [`@cloudflare/playwright-mcp`](https://www.npmjs.com/package/@cloudflare/playwright-mcp). To install it, type:

* npm

  ```sh
  npm i -D @cloudflare/playwright-mcp
  ```

* yarn

  ```sh
  yarn add -D @cloudflare/playwright-mcp
  ```

* pnpm

  ```sh
  pnpm add -D @cloudflare/playwright-mcp
  ```

Deploying the server is then as easy as:

```ts
import { env } from "cloudflare:workers";
import { createMcpAgent } from "@cloudflare/playwright-mcp";


export const PlaywrightMCP = createMcpAgent(env.BROWSER);
export default PlaywrightMCP.mount("/sse");
```

Check out the full code at [GitHub](https://github.com/cloudflare/playwright-mcp).

Learn more about Playwright MCP in our [documentation](https://developers.cloudflare.com/browser-rendering/platform/playwright-mcp/).
