---
title: Browser Rendering Playwright GA, Stagehand support (Beta), and higher
  limits · Changelog
description: Browser Rendering birthday week announcements
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-25-br-playwright-ga-stagehand-limits/
  md: https://developers.cloudflare.com/changelog/2025-09-25-br-playwright-ga-stagehand-limits/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Browser Rendering Playwright GA, Stagehand support (Beta), and higher limits

Sep 25, 2025

[Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

We’re shipping three updates to Browser Rendering:

* Playwright support is now Generally Available and synced with [Playwright v1.55](https://playwright.dev/docs/release-notes#version-155), giving you a stable foundation for critical automation and AI-agent workflows.
* We’re also adding [Stagehand support (Beta)](https://developers.cloudflare.com/browser-rendering/platform/stagehand/) so you can combine code with natural language instructions to build more resilient automations.
* Finally, we’ve tripled [limits](https://developers.cloudflare.com/browser-rendering/platform/limits/#workers-paid) for paid plans across both the [REST API](https://developers.cloudflare.com/browser-rendering/rest-api/) and [Workers Bindings](https://developers.cloudflare.com/browser-rendering/workers-bindings/) to help you scale.

To get started with Stagehand, refer to the [Stagehand](https://developers.cloudflare.com/browser-rendering/platform/stagehand/) example that uses Stagehand and [Workers AI](https://developers.cloudflare.com/workers-ai/) to search for a movie on this [example movie directory](https://demo.playwright.dev/movies), extract its details using natural language (title, year, rating, duration, and genre), and return the information along with a screenshot of the webpage.

```ts
const stagehand = new Stagehand({
  env: "LOCAL",
  localBrowserLaunchOptions: { cdpUrl: endpointURLString(env.BROWSER) },
  llmClient: new WorkersAIClient(env.AI),
  verbose: 1,
});


await stagehand.init();
const page = stagehand.page;


await page.goto('https://demo.playwright.dev/movies');


// if search is a multi-step action, stagehand will return an array of actions it needs to act on
const actions = await page.observe('Search for "Furiosa"');
for (const action of actions)
  await page.act(action);


await page.act('Click the search result');


// normal playwright functions work as expected
await page.waitForSelector('.info-wrapper .cast');


let movieInfo = await page.extract({
  instruction: 'Extract movie information',
  schema: z.object({
    title: z.string(),
    year: z.number(),
    rating: z.number(),
    genres: z.array(z.string()),
    duration: z.number().describe("Duration in minutes"),
  }),
});


await stagehand.close();
```

![Stagehand video](https://developers.cloudflare.com/images/browser-rendering/speedystagehand.gif)
