---
title: Certificate Signing Requests (CSRs) · Cloudflare SSL/TLS docs
description: Generate a Certificate Signing Request (CSR) to get a custom
  certificate from the Certificate Authority (CA) of your choice while
  maintaining control of the private key on Cloudflare. The private key
  associated with the CSR will be generated by Cloudflare and will never leave
  our network.
lastUpdated: 2025-10-28T14:13:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-signing-requests/
  md: https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-signing-requests/index.md
---

Generate a Certificate Signing Request (CSR) to get a custom certificate from the Certificate Authority (CA) of your choice while maintaining control of the private key on Cloudflare. The private key associated with the CSR will be generated by Cloudflare and will never leave our network.

A CSR contains information about your domain: your organization name and address, the common name (domain name), and Subject Alternative Names (SANs).

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | No | No | No | Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) |

## Types of CSRs

You can create two types of CSRs:

* **Zone-level**: Meant only for sign certificates associated with the current zone.
* **Account-level**: Meant for organizations that issue certificates across multiple domains.

## Create and use a CSR

To create a CSR:

1. In the Cloudflare dashboard, go to the **Edge Certificates** page.

   [Go to **Edge Certificates**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/edge-certificates)

2. On **Certificate Signing Request (CSR)**, select **Generate**.

3. Choose a **Scope** (only [certain customers](#types-of-csrs) can choose **Account**).

4. Enter relevant information on the form and select **Create**.

To use a CSR:

1. On the [**Edge Certificates**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/edge-certificates) page, select the CSR record you just created under **Certificate Signing Request (CSR)**.

2. Copy (or select **Click to copy**) the value for **Certificate Signing Request**.

3. Obtain a certificate from the Certificate Authority (CA) of your choice using your CSR.

4. When you [upload the custom certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/uploading/) to Cloudflare, select an **Encoding mode** of **Certificate Signing Request (CSR)** and enter the associated value.

   Note

   You will not see the option to adjust your **Encoding Mode** until after you have created a CSR associated with the specific zone or your account.

## Renew a certificate

When you [renew a custom certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/renewing/), you need to reuse a previously generated CSR.

Note that it is not possible to use a different CSR with the same certificate. In this case, you must upload the certificate as a new certificate, selecting the new CSR.
