---
title: Supported API methods - Ethereum Gateway · Cloudflare Web3 docs
description: |-
  The full list of API methods that are supported by an Ethereum Gateway
  is given below. The gateway returns a 403 if a method is specified that is not
  supported.
lastUpdated: 2024-08-20T21:10:02.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/web3/ethereum-gateway/reference/supported-api-methods/
  md: https://developers.cloudflare.com/web3/ethereum-gateway/reference/supported-api-methods/index.md
---

The full list of API methods that are supported by an Ethereum Gateway is given below. The gateway returns a `403` if a method is specified that is not supported.

For a full list of JSON-RPC API methods, refer to the [JSON-RPC specification](https://github.com/ethereum/execution-apis).

| JSON-RPC method | Cloudflare Ethereum Gateway support |
| - | - |
| [web3\_clientVersion](https://ethereum.org/en/developers/docs/apis/json-rpc/#web3_clientversion) | ✅ |
| [web3\_sha3](https://ethereum.org/en/developers/docs/apis/json-rpc/#web3_sha3) | ✅ |
| [net\_version](https://ethereum.org/en/developers/docs/apis/json-rpc/#net_version) | ✅ |
| [net\_listening](https://ethereum.org/en/developers/docs/apis/json-rpc/#net_listening) | ✅ |
| [eth\_syncing](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_syncing) | ✅ |
| [eth\_mining](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_mining) | ✅ |
| [eth\_gasPrice](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_gasprice) | ✅ |
| [eth\_feeHistory](https://github.com/ethereum/execution-apis)[1](#user-content-fn-2) | ✅ |
| [eth\_blockNumber](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_blocknumber) | ✅ |
| [eth\_chainId](https://github.com/ethereum/execution-apis) | ✅ |
| [eth\_getBalance](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getbalance) | ✅ |
| [eth\_getStorageAt](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getstorageat) | ✅ |
| [eth\_getTransactionCount](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_gettransactioncount) | ✅ |
| [eth\_getBlockTransactionCountByHash](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getblocktransactioncountbyhash) | ✅ |
| [eth\_getBlockTransactionCountByNumber](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getblocktransactioncountbynumber) | ✅ |
| [eth\_getUncleCountByBlockHash](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getunclecountbyblockhash) | ✅ |
| [eth\_getUncleCountByBlockNumber](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getunclecountbyblocknumber) | ✅ |
| [eth\_getCode](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getcode) | ✅ |
| [eth\_sendRawTransaction](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_sendrawtransaction) | ✅ |
| [eth\_call](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_call) | ✅ |
| [eth\_estimateGas](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_estimategas) | ✅ |
| [eth\_getBlockByHash](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getblockbyhash) | ✅ |
| [eth\_getBlockByNumber](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getblockbynumber) | ✅ |
| [eth\_getTransactionByHash](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_gettransactionbyhash) | ✅ |
| [eth\_getTransactionByBlockHashAndIndex](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_gettransactionbyblockhashandindex) | ✅ |
| [eth\_getTransactionByBlockNumberAndIndex](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_gettransactionbyblocknumberandindex) | ✅ |
| [eth\_getTransactionReceipt](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_gettransactionreceipt) | ✅ |
| [eth\_getUncleByBlockHashAndIndex](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getunclebyblockhashandindex) | ✅ |
| [eth\_getUncleByBlockNumberAndIndex](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getunclebyblocknumberandindex) | ✅ |
| [eth\_getLogs](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getlogs)[2](#user-content-fn-1) | ✅ |
| [eth\_getWork](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getwork) | ✅ |
| [eth\_getProof](https://ethereum.github.io/execution-apis/api-documentation/) | ✅ |
| [net\_peerCount](https://ethereum.org/en/developers/docs/apis/json-rpc/#net_peercount) | ❌ |
| [eth\_protocolVersion](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_protocolversion) | ❌ |
| [eth\_coinbase](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_coinbase) | ❌ |
| [eth\_hashrate](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_hashrate) | ❌ |
| [eth\_accounts](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_accounts) | ❌ |
| [eth\_sign](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_sign) | ❌ |
| [eth\_sendTransaction](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_sendtransaction) | ❌ |
| [eth\_getCompilers](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getcompilers) | ❌ |
| [eth\_compileLLL](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_compilelll) | ❌ |
| [eth\_compileSolidity](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_compile_solidity) | ❌ |
| [eth\_compileSerpent](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_compileserpent) | ❌ |
| [eth\_newFilter](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_newfilter) | ❌ |
| [eth\_newBlockFilter](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_newblockfilter) | ❌ |
| [eth\_newPendingTransactionFilter](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_newpendingtransactionfilter) | ❌ |
| [eth\_uninstallFilter](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_uninstallfilter) | ❌ |
| [eth\_getFilterChanges](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getfilterchanges) | ❌ |
| [eth\_getFilterLogs](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_getfilterlogs) | ❌ |
| [eth\_submitWork](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_submitwork) | ❌ |
| [eth\_submitHashrate](https://ethereum.org/en/developers/docs/apis/json-rpc/#eth_submithashrate) | ❌ |

## Trace methods

EVM traces are a way to track the execution of smart contracts on the Ethereum blockchain. It records all the steps taken by the Ethereum Virtual Machine (EVM) as it runs the smart contract. This includes information like the specific operation that was executed, how much gas it cost, and any changes made to the blockchain as a result. The trace module is a tool that allows developers to access and analyze these traces, which can be useful for debugging, testing, and monitoring smart contracts. It can be used to identify and fix errors, optimize performance, and gain insight into how the smart contract is interacting with the blockchain.

### trace\_filter

The `trace_filter` method retrieves the traces of multiple transactions in a single request. This method is particularly useful for debugging and monitoring specific addresses on the Ethereum blockchain.

#### Request Parameters

* `fromBlock`: `Quantity` or `Tag` - (optional) The block number to start receiving traces from.
* `toBlock`: `Quantity` or `Tag` - (optional) The block number to stop receiving traces at.
* `fromAddress`: `Array` - (optional) An array of addresses to start receiving traces from.
* `toAddress`: `Address` - (optional) An array of addresses to stop retrieving traces at.
* `after`: `Quantity` - (optional) The offset trace number
* `count`: `Quantity` - (optional) The amount of traces to return.

#### Returns

This method returns an `Array` of traces matching the given filter.

#### Example

```sh
curl https://web3-trial.cloudflare-eth.com/v1/mainnet \
-X POST \
-H 'Content-Type: application/json' \
--data '{
    "jsonrpc":"2.0",
    "method":"trace_filter",
    "params":[
        {
            "count": 200,
            "fromBlock": "0xccb943",
            "toBlock": "0xccbc62",
            "fromAddress": [
                "0xEdC763b3e418cD14767b3Be02b667619a6374076"
            ]
        }
    ],
    "id":1
    }'
```

#### Response

```json
{
  "jsonrpc": "2.0",
  "result": [
    {
      "action": {
        "from": "0xedc763b3e418cd14767b3be02b667619a6374076",
        "callType": "call",
        "gas": "0x8462",
        "input": "0x095ea7b30000000000000000000000007a250d5630b4cf539739df2c5dacb4c659f2488dffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
        "to": "0x7ff4169a6b5122b664c51c95727d87750ec07c84",
        "value": "0x0"
      },
      "blockHash": "0x351e7c06ec010c8f7e7358eb580238dd23e1e129be96822aa93ebb6da08558e6",
      "blockNumber": 13416771,
      "result": {
        "gasUsed": "0x6009",
        "output": "0x0000000000000000000000000000000000000000000000000000000000000001"
      },
      "subtraces": 0,
      "traceAddress": [],
      "transactionHash": "0x054bbb9fbb855bf23f755e548c7409f45fc5eff8a824b2ad06380bc038d7b049",
      "transactionPosition": 54,
      "type": "call"
    }
  ],
  "id": 1
}
```

### Limitations

The `trace_filter` method has some limitations to ensure that our nodes are not overloaded.

* The block range for the `trace_filter` method is limited to 800 blocks.
* The trace `count` is limited to 200

## Footnotes

1. **Limitations**: Max block count of 10. [↩](#user-content-fnref-2)

2. **Limitations**: Max block range of 800 blocks. [↩](#user-content-fnref-1)
